/*
    Copyright  1995-2001, The AROS Development Team. All rights reserved.
    $Id: apple_f.c,v 1.1 2012/02/09 21:57:07 tokai Exp $

    Desc: French Powerbook Keymap
    Lang: English
*/

#include <devices/keymap.h>

#define	VERSION		51
#define	REVISION	2
#define	KMDESC		"French Apple keyboard"
#define	KMID		"apple_f 51.2"
#define KMNAME		"apple_f"
#define KMLANG      "Franais"
#define KMLANGINT   "French"
#define KMCODEPAGE  "ISO-8859-1"

#define CONST const

extern CONST char  keymapname[];

extern CONST UBYTE lokeymaptypes[];
extern CONST IPTR  lokeymap[];
extern CONST UBYTE locapsable[];
extern CONST UBYTE lorepeatable[];

extern CONST UBYTE hikeymaptypes[];
extern CONST IPTR  hikeymap[];
extern CONST UBYTE hicapsable[];
extern CONST UBYTE hirepeatable[];

static const struct Resident ROMTag;

struct ExtendedKeyMapNode km =
{
    {
	NULL, NULL, NT_EXTENDED, 'E', (char*) keymapname
    },
    {
	(UBYTE *)lokeymaptypes,
	(IPTR  *)lokeymap,
	(UBYTE *)locapsable,
	(UBYTE *)lorepeatable,
	(UBYTE *)hikeymaptypes,
	(IPTR  *)hikeymap,
	(UBYTE *)hicapsable,
	(UBYTE *)hirepeatable
    },
    0,
    (struct Resident *)&ROMTag,
    0
};

CONST char keymapname[] = KMNAME;

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#define N KC_NOQUAL
#define S KCF_SHIFT
#define A KCF_ALT
#define C KCF_CONTROL
#define D KCF_DEAD
#define V KC_VANILLA
#define ST KCF_STRING
#define NOP KCF_NOP

#define EUR 0xA4 /* ISO 8859-15: Euro = 164 = 0xA4) */

CONST UBYTE lokeymaptypes[] =
{
    S,		/* 00 */
    S|A,	/* 01 */
    S|A,	/* 02 */
    S|A,	/* 03 */
    S|A,	/* 04 */
    S|A,	/* 05 */
    S|A,	/* 06 */
    S|A,	/* 07 */
    ST|V,	/* 08 */
    S|A,	/* 09 */
    S|A,	/* 0A */
    S|A,	/* 0B */
    S|A,	/* 0C */
    S,		/* 0D */
    N,		/* 0E */
    N,		/* 0F */
    D|V,	/* 10 a */
    V,		/* 11 z */
    D|V,	/* 12 e */
    V,		/* 13 r */
    V,		/* 14 t */
    D|V,	/* 15 y */
    D|V,	/* 16 u */
    D|V,	/* 17 i */
    D|V,	/* 18 o */
    V,		/* 19 p */
    D|S|A,	/* 1A */
    S|A,	/* 1B */
    N,		/* 1C */
    N,		/* 1D */
    N,		/* 1E */
    N,		/* 1F */
    V,		/* 20 q */
    V,		/* 21 s */
    V,		/* 22 d */
    D|V,	/* 23 f */
    D|V,	/* 24 g */
    D|V,	/* 25 h */
    D|V,	/* 26 j */
    D|V,	/* 27 k */
    V,		/* 28 l */
    V,		/* 29 m */
    S|A,	/* 2A */
    S,		/* 2B */
    N,		/* 2C */
    N,		/* 2D */
    N,		/* 2E */
    N,		/* 2F */
    S,		/* 30 */
    V,		/* 31 w */
    V,		/* 32 x */
    V,		/* 33 c */
    V,		/* 34 v */
    V,		/* 35 b */
    D|V,	/* 36 n */
    S|A,	/* 37 */
    S|A,	/* 38 */
    S|A,	/* 39 */
    S|A,	/* 3A */
    N,		/* 3B */
    N,		/* 3C */
    N,		/* 3D */
    N,		/* 3E */
    N,		/* 3F */

};

CONST UBYTE hikeymaptypes[] =
{
    D|A,	/* 40 SPACE */
    N,		/* 41 BACKSPACE */
    ST|S,	/* 42 TAB */
    N,		/* 43 ENTER */
    C,		/* 44 RETURN */
    A,		/* 45 ESCAPE */
    N,		/* 46 DEL  */
    ST|S,	/* 47 INSERT */
    ST|S,	/* 48 PAGE UP */
    ST|S,	/* 49 PAGE DOWN */
    N,		/* 4A NUMERIC PAD - */
    ST|S,	/* 4B F11 */
    ST|S,	/* 4C CURSORUP*/
    ST|S,	/* 4D CURSORDOWN */
    ST|S,	/* 4E CURSORRIGHT */
    ST|S,	/* 4F CURSORLEFT */
    ST|S,	/* 50 F1 */
    ST|S,	/* 51 F2 */
    ST|S,	/* 52 F3 */
    ST|S,	/* 53 F4 */
    ST|S,	/* 54 F5 */
    ST|S,	/* 55 F6 */
    ST|S,	/* 56 F7 */
    ST|S,	/* 57 F8 */
    ST|S,	/* 58 F9 */
    ST|S,	/* 59 F10 */
    NOP,	/* 5A NUMLOCK */
    N,		/* 5B NUMPAD ) */
    N,		/* 5C NUMPAD / */
    N,		/* 5D NUMPAD * */
    N,		/* 5E NUMPAD + */
    ST,		/* 5F HELP */
    NOP,	/* 60 LEFT SHIFT*/
    NOP,	/* 61 RIGHT SHIFT */
    NOP,	/* 62 CAPS LOCK */
    NOP,	/* 63 CONTROL */
    NOP,	/* 64 LALT */
    NOP,	/* 65 RALT */
    NOP,	/* 66 LCOMMAND */
    NOP,	/* 67 RCOMMAND */
    NOP,	/* 68 LEFT MOUSE BUTTON*/
    NOP,	/* 69 RIGHT MOUSE BUTTON */
    NOP,	/* 6A MIDDLE MOUSE BUTTON */
    ST|S,	/* 6B SCR LOCK */
    ST|S,	/* 6C PRT SCREEN */
    ST|S,	/* 6D NUM LOCK */
    ST|S,	/* 6E PAUSE/BREAK ??*/
    ST|S,	/* 6F F12 ?? */
    ST|C,	/* 70 HOME ?? */
    ST|C,	/* 71 END ?? */
    NOP,	/* 72 */
    NOP,	/* 73 */
    NOP,	/* 74 */
    NOP,	/* 75 */
    NOP,	/* 76 */
    NOP,	/* 77 */
    NOP,	/* 78 */
    NOP,	/* 79 */
    NOP,	/* 7A */
    NOP,	/* 7B */
    NOP,	/* 7C */
    NOP,	/* 7D */
    NOP,	/* 7E */
    NOP		/* 7F */

};

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#undef STRING
#undef DEAD
#undef BYTES

#define STRING(x) (IPTR)(x)
#define DEAD(x)	  (IPTR)(x)
#define BYTES(b0, b1, b2, b3) \
	(((UBYTE)(b3))<<24) | (((UBYTE)(b2))<<16) | (((UBYTE)(b1))<<8) | (((UBYTE)(b0))<<0)

#define N 0
#define D DPF_DEAD
#define M DPF_MOD

const UBYTE key08_descr[] =
{
    1, 16, 1, 17,
    1, 18, 1, 19,
    1, 20, 1, 21,
    1, 22, 1, 23,
    '!', '8', '\\', '',
    0x1f, '8', 0x1c, 0x91,
};

const UBYTE key10_descr[] =
{
    M, 16, M, 22,
    N, '', N, '',
    N, 0x01, N, 0x01,
    N, 0x81, N, 0x81,
    'a', '', '', '', '', '',
    'A', '', '', '', '', '',
};

const UBYTE key12_descr[] =
{
    M, 16, M, 22,
    N, EUR, N, '',
    N, 0x05, N, 0x05,
    N, 0x85, N, 0x85,
    'e', '', '', '', 'e', '',
    'E', '', '', '', 'E', '',
};

const UBYTE key15_descr[] =
{
    M, 16, M, 22,
    N, '', N, '',
    N, 0x19, N, 0x19,
    N, 0x99, N, 0x99,
    'y', '', 'y', 'y', 'y', '',
    'Y', '', 'Y', 'Y', 'Y', 'Y',
};

const UBYTE key16_descr[] =
{
    M, 16, M, 22,
    N, '', N, '',
    N, 0x15, N, 0x15,
    N, 0x95, N, 0x95,
    'u', '', '', '', 'u', '',
    'U', '', '', '', 'U', '',
};

const UBYTE key17_descr[] =
{
    M, 16, M, 22,
    N, '', N, '',
    N, 0x09, N, 0x09,
    N, 0x89, N, 0x89,
    'i', '', '', '', 'i', '',
    'I', '', '', '', 'I', '',
};

const UBYTE key18_descr[] =
{
    M, 16, M, 22,
    N, '', N, '',
    N, 0x0f, N, 0x0f,
    N, 0x8f, N, 0x8f,
    'o', '', '', '', '', '',
    'O', '', '', '', '', '',
};

const UBYTE key1a_descr[] =
{
    D, 3, D, 5,
    N, '[', N, '{',
};

const UBYTE key23_descr[] =
{
    N, 'f', N, 'F',
    D, 1, D, 1,
    N, 0x06, N, 0x06,
    N, 0x86, N, 0x86,
};

const UBYTE key24_descr[] =
{
    N, 'g', N, 'G',
    D, 2, D, 2,
    N, 0x07, N, 0x07,
    N, 0x87, N, 0x87,
};

const UBYTE key25_descr[] =
{
    N, 'h', N, 'H',
    D, 3, D, 3,
    N, 0x08, N, 0x08,
    N, 0x88, N, 0x88,
};

const UBYTE key26_descr[] =
{
    N, 'j', N, 'J',
    D, 4, D, 4,
    N, 0x0a, N, 0x0a,
    N, 0x8a, N, 0x8a,
};

const UBYTE key27_descr[] =
{
    N, 'k', N, 'K',
    D, 5, D, 5,
    N, 0x0b, N, 0x0b,
    N, 0x8b, N, 0x8b,
};

const UBYTE key36_descr[] =
{
    M, 16, M, 22,
    N, '', N, '',
    N, 0x0e, N, 0x0e,
    N, 0x8e, N, 0x8e,
    'n', 'n', 'n', 'n', '', 'n',
    'N', 'N', 'N', 'N', '', 'N',
};

const UBYTE key40_descr[] =
{
    M, 4,
    N, 0xa0,
    ' ', 0xb4, '`', '^', '~', 0xa8,
};

CONST IPTR lokeymap[] =
{
    BYTES('<', '>', '<', '>'),		/* 00 Left of 1 Key */
    BYTES('&', '1', '', ''),		/* 01 1 */
    BYTES('', '2', '~', ''),		/* 02 2 */
    BYTES('"', '3', '#', ''),		/* 03 3 */
    BYTES('\'','4', '{', ''),		/* 04 4 */
    BYTES('(', '5', '[', ''),		/* 05 5 */
    BYTES('', '6', '|', ''),		/* 06 6 */
    BYTES('', '7', '`', ''),		/* 07 7 */
    STRING(key08_descr),		/* 08 8 */
    BYTES('', '9', '^', ''),		/* 09 9 */
    BYTES('', '0', '@', ''),		/* 0A 0 */
    BYTES(')', '', ']', '-'),		/* 0B Right of 0 */
    BYTES('-', '_', '}', '='),		/* 0C 2nd right of 0 */
    BYTES('`','','`', ''),		/* 0D 3rd right of 0 */
    BYTES(0, 0, 0, 0),			/* 0E undefined */
    BYTES('0', '0', '0', '0'),		/* 0F NUM 0 */
    DEAD(key10_descr),			/* 10 */
    BYTES('z', 'Z', '', ''),		/* 11 */
    DEAD(key12_descr),			/* 12 */
    BYTES('r', 'R', '', ''),		/* 13 */
    BYTES('t', 'T', '', ''),		/* 14 */
    DEAD(key15_descr),			/* 15 */
    DEAD(key16_descr),			/* 16 */
    DEAD(key17_descr),			/* 17 */
    DEAD(key18_descr),			/* 18 */
    BYTES('p', 'P', '', ''),		/* 19 */

    DEAD(key1a_descr),			/* 1A */
    BYTES('$', '*', '', '}'),		/* 1B */
    BYTES(0, 0, 0, 0),			/* 1C undefined */
    BYTES('1', '1', '1', '1'),		/* 1D NUM 1*/
    BYTES('2', '2', '2', '2'),		/* 1E NUM 2*/
    BYTES('3', '3', '3', '3'),		/* 1F NUM 3*/

    BYTES('q', 'Q', '', ''),		/* 20 */
    BYTES('s', 'S', '', ''),		/* 21 */
    BYTES('d', 'D', '', ''),		/* 22 */
    DEAD(key23_descr),			/* 23 */
    DEAD(key24_descr),			/* 24 */
    DEAD(key25_descr),			/* 25 */
    DEAD(key26_descr),			/* 26 */
    DEAD(key27_descr),			/* 27 */
    BYTES('l', 'L', '', ''),		/* 28 */

    BYTES('m', 'M', ';', ':'),		/* 29 */
    BYTES('', '%', '\'','"'),		/* 2A */
    BYTES('*', '', '*', ''),		/* 2B */
    BYTES(0, 0, 0, 0),			/* 2C undefined */
    BYTES('4', '4', '4', '4'),		/* 2D NUM 4 */
    BYTES('5', '5', '5', '5'),		/* 2E NUM 5 */
    BYTES('6', '6', '6', '6'),		/* 2F NUM 6 */
    BYTES('@', '#', '@', '#'),		/* 30 */
    BYTES('w', 'W', '', ''),		/* 31 */
    BYTES('x', 'X', '', ''),		/* 32 */
    BYTES('c', 'C', '', ''),		/* 33 */
    BYTES('v', 'V', '', ''),		/* 34 */
    BYTES('b', 'B', '', ''),		/* 35 */
    DEAD(key36_descr),			/* 36 */
    BYTES(',', '?', '', ''),		/* 37 */

    BYTES(';', '.', ',', '<'),		/* 38 */
    BYTES(':', '/', '.', '>'),		/* 39 */
    BYTES('=', '+', '/', '?'),		/* 3A */
    BYTES(0, 0, 0, 0),	/* 3B */
    BYTES('.', '.', '.', '.'),		/* 3C NUM . */
    BYTES('7', '7', '7', '7'),		/* 3D NUM 7 */
    BYTES('8', '8', '8', '8'),		/* 3E NUM 8 */
    BYTES('9', '9', '9', '9'),		/* 3F NUM 9 */
};

#include "standard.h"

#undef BYTES
#define BYTES(b0, b1, b2, b3) \
	(((UBYTE)(b3))<<0) | (((UBYTE)(b2))<<8) | (((UBYTE)(b1))<<16) | (((UBYTE)(b0))<<24)

CONST IPTR hikeymap[] =
{
    DEAD(key40_descr),
    BYTES(8, 8, 8, 8),		/* 41 BACKSPACE*/
    STRING(tab_descr),		/* 42 TAB */
    BYTES(13, 13, 13, 13),	/* 43 ENTER */
    BYTES(0, 0, 10, 13),	/* 44 RETURN */
    BYTES(0, 0, 0x9B, 27),	/* 45 ESCAPE */
    BYTES(127, 127, 127, 127),	/* 46 DEL */
    STRING(insert_descr),	/* 47 INSERT ?? */
    STRING(pageup_descr),	/* 48 PAGEUP ?? */
    STRING(pagedown_descr),	/* 49 PAGEDOWN ?? */
    BYTES('-', '-', '-', '-'),	/* 4A NUMPAD - */
    STRING(f11_descr),		/* 4B F11 ?? */
    STRING(up_descr),		/* 4C CURSOR UP*/
    STRING(down_descr),		/* 4D CURSOR DOWN*/
    STRING(right_descr),	/* 4E CURSOR RIGHT */
    STRING(left_descr),		/* 4F CURSOR LEFT */
    STRING(f1_descr),		/* 50 F1 */
    STRING(f2_descr),		/* 51 */
    STRING(f3_descr),		/* 52 */
    STRING(f4_descr),		/* 53 */
    STRING(f5_descr),		/* 54 */
    STRING(f6_descr),		/* 55 */
    STRING(f7_descr),		/* 56 */
    STRING(f8_descr),		/* 57 */
    STRING(f9_descr),		/* 58 */
    STRING(f10_descr),		/* 59 */
    BYTES(0, 0, 0, 0),		/* 5A */
    BYTES(0, 0, 0, 0),		/* 5B */
    BYTES('/', '/', '/', '/'),	/* 5C */
    BYTES('*', '*', '*', '*'),	/* 5D */
    BYTES('+', '+', '+', '+'),	/* 5E */
    STRING(help_descr),		/* 5F HELP */
    BYTES(0, 0, 0, 0),		/* 60 */
    BYTES(0, 0, 0, 0),		/* 61 */
    BYTES(0, 0, 0, 0),		/* 62 */
    BYTES(0, 0, 0, 0),		/* 63 */
    BYTES(0, 0, 0, 0),		/* 64 */
    BYTES(0, 0, 0, 0),		/* 65 */
    BYTES(0, 0, 0, 0),		/* 66 */
    BYTES(0, 0, 0, 0),		/* 67 */
    BYTES(0, 0, 0, 0),		/* 68 */
    BYTES(0, 0, 0, 0),		/* 69 */
    BYTES(0, 0, 0, 0),		/* 6A */
    STRING(scrlck_descr),	/* 6B */
    STRING(prtsc_descr),	/* 6C */
    STRING(numlock_descr),	/* 6D */
    STRING(pausebreak_descr),	/* 6E PAUSE/BREAK ?? */
    STRING(f12_descr),		/* 6F F12 ?? */
    STRING(home_descr),		/* 70 HOME ?? */
    STRING(end_descr),		/* 71 END ?? */
    BYTES(0, 0, 0, 0),		/* 72 */
    BYTES(0, 0, 0, 0),		/* 73 */
    BYTES(0, 0, 0, 0),		/* 74 */
    BYTES(0, 0, 0, 0),		/* 75 */
    BYTES(0, 0, 0, 0),		/* 76 */
    BYTES(0, 0, 0, 0),		/* 77 */
    BYTES(0, 0, 0, 0),		/* 78 */
    BYTES(0, 0, 0, 0),		/* 79 */
    BYTES(0, 0, 0, 0),		/* 7A */
    BYTES(0, 0, 0, 0),		/* 7B */
    BYTES(0, 0, 0, 0),		/* 7C */
    BYTES(0, 0, 0, 0),		/* 7D */
    BYTES(0, 0, 0, 0),		/* 7E */
    BYTES(0, 0, 0, 0),		/* 7F */
};

#undef SETBITS

#define SETBITS(b0, b1, b2, b3, b4, b5, b6, b7) \
	(b0<<0)|(b1<<1)|(b2<<2)|(b3<<3)|(b4<<4)|(b5<<5)|(b6<<6)|(b7<<7)

CONST UBYTE locapsable[] =
{
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 00 - 07 */
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 08 - 0F */

    SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 10 - 17 */
    SETBITS(1, 1, 0, 0, 0, 0, 0, 0),	/* 18 - 1F */

    SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 20 - 27 */
    SETBITS(1, 1, 0, 0, 0, 0, 0, 0),	/* 28 - 2F */

    SETBITS(0, 1, 1, 1, 1, 1, 1, 0),	/* 30 - 37 */
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 38 - 3F */
};

CONST UBYTE hicapsable[] =
{
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 40 - 47 */
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 48 - 4F */

    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 58 - 5F */

    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */

    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};

CONST UBYTE lorepeatable[] =
{
    SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 00 - 07 */
    SETBITS(1, 1, 1, 1, 1, 1, 0, 1),	/* 08 - 0F */

    SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 10 - 17 */
    SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 18 - 1F */

    SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 20 - 27 */
    SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 28 - 2F */

    SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 30 - 37 */
    SETBITS(1, 1, 1, 0, 1, 1, 1, 1)	/* 38 - 3F */
};

CONST UBYTE hirepeatable[] =
{
    SETBITS(1, 1, 1, 0, 0, 0, 1, 0),	/* 40 - 47 */
    SETBITS(1, 1, 1, 0, 1, 1, 1, 1),	/* 48 - 4F */

    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
    SETBITS(0, 0, 1, 1, 1, 1, 1, 0),	/* 58 - 5F */

    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */

    SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
    SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};

#include "query.c"
